import '../../domain/entities/order_entity.dart';

class OrderModel {
  OrderModel({
    required this.id,
    required this.symbol,
    required this.type,
    required this.side,
    required this.amount,
    required this.price,
    required this.cost,
    required this.status,
    required this.createdAt,
  });

  final String id;
  final String symbol;
  final String type;
  final String side;
  final double amount;
  final double price;
  final double cost;
  final String status;
  final DateTime createdAt;

  factory OrderModel.fromJson(Map<String, dynamic> json) {
    return OrderModel(
      id: json['id'].toString(),
      symbol: json['symbol'] ?? '',
      type: json['type'] ?? '',
      side: json['side'] ?? '',
      amount: (json['amount'] ?? 0).toDouble(),
      price: (json['price'] ?? 0).toDouble(),
      cost: (json['cost'] ?? 0).toDouble(),
      status: json['status'] ?? '',
      createdAt: DateTime.tryParse(json['createdAt']?.toString() ?? '') ??
          DateTime.now(),
    );
  }

  OrderEntity toEntity() {
    return OrderEntity(
      id: id,
      symbol: symbol,
      type: type,
      side: side,
      amount: amount,
      price: price,
      cost: cost,
      status: status,
      createdAt: createdAt,
    );
  }
}
